; Icon.asm - demonstrates use of icons in a resource file
;
; Resources are stored in a resource file which will be linked in at link time,
; but because we like to refer to them by defines rather than number we include
; a file containing those defines. This is generated automatically from the
; include file used by the .rc file.
;

%define _WINMESSAGES_
%include "Gaz\Win32\Include\Windows.inc"

%include "Icon.ash"

[BITS 32]
[section .text]

procglobal WinMain, hInstance, hPrevInstance, lpszCmdLine, nCmdShow
	ddlocal		_hwnd
	struclocal	_wndclass, WNDCLASSEX, _msg, MSG
	endlocals
	WinMainPrologue
	mov	esi, ._wndclass
	mov	edi, ._msg
	mov	[esi + WNDCLASSEX.cbSize], dword WNDCLASSEX_size
	mov	[esi + WNDCLASSEX.style], dword CS_HREDRAW | CS_VREDRAW
	mov	[esi + WNDCLASSEX.lpfnWndProc], dword _WndProc
	mov	[esi + WNDCLASSEX.cbClsExtra], dword 0
	mov	[esi + WNDCLASSEX.cbWndExtra], dword 0
	mov	eax, .hInstance
	mov	[esi + WNDCLASSEX.hInstance], eax
	;
	; We've already seen loading a standard inbuilt Windows icon, but now
	; we want to load an icon from our resource file. To do this we need
	; to know two things - the instance of the module (ie .exe or .dll)
	; holding the resource and an identifier for that resource. Since the
	; resource file will be linked into our executable, we can use the
	; instance handle for the former and the identifier is defined via
	; an equ in Icon.ash:
	;
	sc LoadIcon, .hInstance, IDI_CHEMICAL
	mov	[esi + WNDCLASSEX.hIcon], eax
	;
	; The WNDCLASSEX structure has a member which can be set to hold a
	; handle to a small icon - this is used in the taskbar and the window's
	; title (top-left corner), whilst the other icon is used for the
	; file's icon (eg in Windows Explorer) and is also displayed in the
	; Alt-Tab list. For this example, I have set the small icon to be a
	; microprocessor chip image to show the difference. Note that this
	; is unused in Windows NT though.
	;
	sc LoadIcon, .hInstance, IDI_CHIP
	mov	[esi + WNDCLASSEX.hIconSm], eax
	;
	; We can also load cursors in exactly the same way, and the window
	; class structure has a field for setting the cursor shape whenever
	; the mouse is over the application window. Previously, we have just
	; used an inbuilt one, but here we use one from the resource file.
	;
	; Note the similarity to loading icons:
	;
	sc LoadCursor, .hInstance, IDC_NEGATIVE
	mov	[esi + WNDCLASSEX.hCursor], eax
	;
	; Everything else is the standard window creation and message painting
	;
	sc GetStockObject, WHITE_BRUSH
	mov	[esi + WNDCLASSEX.hbrBackground], eax
	mov	[esi + WNDCLASSEX.lpszMenuName], dword NULL
	TEXTlocal szClassName, 'MyClass',0
	mov	[esi + WNDCLASSEX.lpszClassName], dword .szClassName
	sc RegisterClassEx, esi
	cmp	eax, TRUE
	je	near _WinMain_Fail
	TEXTlocal szWndCaption, 'Icons',0
	sc CreateWindowEx, 0, .szClassName, .szWndCaption, WS_OVERLAPPEDWINDOW | WS_VISIBLE, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, NULL, NULL, .hInstance, NULL
	mov	._hwnd, eax
	sc ShowWindow, ._hwnd, .nCmdShow
	sc UpdateWindow, ._hwnd
_WinMain_Loop:
	sc GetMessage, ._msg, NULL, 0, 0
	cmp	eax, TRUE
	jne	_WinMain_Loop_End
	sc TranslateMessage, ._msg
	sc DispatchMessage, ._msg
	jmp	_WinMain_Loop
_WinMain_Loop_End:
	mov	eax, [edi + MSG.wParam]
	jmp	_WinMain_End
_WinMain_Fail:
	TEXTlocal szErrorMsg, 'Failed to register window class!',0
	sc MessageBox, NULL, .szErrorMsg, .szWndCaption, MB_ICONERROR
_WinMain_End:
	WinMainEpilogue
endproc
;
;-----------------------------------------------------------------------
;
proc _WndProc, hwnd, message, wParam, lParam
	ddlocal		_hdc
	struclocal	_rect, RECT, _ps, PAINTSTRUCT
	endlocals
	CallbackPrologue
	switch .message
		case WM_PAINT
			sc BeginPaint, .hwnd, ._ps
			mov	._hdc, eax
			sc GetClientRect, .hwnd, ._rect
			TEXTlocal szWndText, 'Icons',0
			sc DrawText, ._hdc, .szWndText, -1, ._rect, DT_SINGLELINE | DT_CENTER | DT_VCENTER
			sc EndPaint, .hwnd, ._ps
			xor	eax,eax
			break
		case WM_DESTROY
			sc PostQuitMessage, 0
			xor	eax,eax
			break
		default
			sc DefWindowProc, .hwnd, .message, .wParam, .lParam
	switchend
	CallbackEpilogue
endproc

[section .bss bss align=16]

[section .data]
